package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.adapter.LeaderAdapter
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.model.LeaderModel
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.LeaderResponse
import com.burhanstore.neonbubblequest.databinding.ActivityLeaderBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

class LeaderActivity : AppCompatActivity() {
    private lateinit var binding: ActivityLeaderBinding
    private lateinit var activity: Activity
    private lateinit var manager: UserManager
    private var uid: String = ""


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLeaderBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this

        manager = UserManager.getInstance(activity)
        uid = manager.getUser()?.u_id ?: ""
        DialogManager.initDialog(activity)


        binding.imageView2.setClick {
            finish()
        }


        binding.coinsTextview.text = manager.getUser()?.point
        get_leader()
    }


    private fun get_leader() {

        val json = JsonObject().apply {
            addProperty("action", "get_leader")
        }

        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("LeaderActivity", "Success: $response")

                    lifecycleScope.launch {
                        val data_response = Gson().fromJson(response, LeaderResponse::class.java)
                        val data = data_response.data
                        update_redeems(data)
                    }


                }

                override fun onError(code: Int, message: String?) {
                    Log.e("LeaderActivity", "Error $code: $message")

                }

                override fun onException(exception: Exception) {
                    Log.e("LeaderActivity", "Exception: ", exception)

                }
            })


    }


    private fun update_redeems(trackList: List<LeaderModel>) {
        if (trackList.isEmpty()) {
            //       binding.ly2.visibility = View.VISIBLE
            return
        }

        val trackAdapter = LeaderAdapter(this, trackList) { selectedItem ->
        }

        binding.leaderList.layoutManager = LinearLayoutManager(this)
        binding.leaderList.adapter = trackAdapter
        binding.leaderList.visibility = View.VISIBLE

    }

}